---
title: "Features"
description: "Discover the different features supported by html2canvas"
---

Below is a list of all the supported CSS properties and values.

 - background
   - background-clip (**Does not support `text`**)
   - background-color
   - background-image
       - url()
       - linear-gradient()
       - radial-gradient()
   - background-origin 
   - background-position
   - background-size   
 - border
   - border-color
   - border-radius
   - border-style (**Only supports `solid`**)
   - border-width
 - bottom
 - box-sizing
 - content
 - color
 - display
 - flex
 - float
 - font
   - font-family
   - font-size
   - font-style
   - font-variant
   - font-weight
 - height
 - left
 - letter-spacing
 - line-break
 - list-style
    - list-style-image
    - list-style-position
    - list-style-type
 - margin
 - max-height
 - max-width
 - min-height
 - min-width
 - opacity
 - overflow
 - overflow-wrap
 - padding
 - position
 - right
 - text-align
 - text-decoration
   - text-decoration-color
   - text-decoration-line
   - text-decoration-style (**Only supports `solid`**)
 - text-shadow
 - text-transform 
 - top
 - transform (**Limited support**)
 - visibility
 - white-space
 - width
 - word-break
 - word-spacing
 - word-wrap
 - z-index
    
## Unsupported CSS properties
These CSS properties are **NOT** currently supported
 - [background-blend-mode](https://github.com/niklasvh/html2canvas/issues/966)
 - [border-image](https://github.com/niklasvh/html2canvas/issues/1287)
 - [box-decoration-break](https://github.com/niklasvh/html2canvas/issues/552)
 - [box-shadow](https://github.com/niklasvh/html2canvas/pull/1086)
 - [filter](https://github.com/niklasvh/html2canvas/issues/493)
 - [font-variant-ligatures](https://github.com/niklasvh/html2canvas/pull/1085)
 - [mix-blend-mode](https://github.com/niklasvh/html2canvas/issues/580)
 - [object-fit](https://github.com/niklasvh/html2canvas/issues/1064)
 - [repeating-linear-gradient()](https://github.com/niklasvh/html2canvas/issues/1162)
 - [writing-mode](https://github.com/niklasvh/html2canvas/issues/1258)
 - [zoom](https://github.com/niklasvh/html2canvas/issues/732)

