---
layout: layout
bodyclass: about
include_prefix: ./
---
<!-- TODO: Try to separate markup and content -->
<section class="docs-text-styling about-panel about-panel--text mdl-cell mdl-cell--12-col">
  <dl>
    <dt>Material Design Lite</dt>
    <dd>
      Material Design Lite lets you add a [Material Design](http://google.com/design/spec) look and feel to your websites. It doesn’t rely on any JavaScript frameworks and aims to optimize for cross-device use, gracefully degrade in older browsers, and offer an experience that is immediately accessible. [Get started now](started/index.html).
    </dd>
  </dl>
</section>

<section class="about-panel about-panel--templates mdl-cell mdl-cell--12-col" data-target="templates/index.html">
  Templates
</section>

<section class="docs-text-styling about-panel about-panel--text mdl-cell mdl-cell--12-col">
  <p>
    The MDL components are created with CSS, JavaScript, and HTML. You can use the components to construct web pages and web apps that are attractive, consistent, and functional. Pages developed with MDL will adhere to modern web design principles like browser portability, device independence, and graceful degradation.
  </p>
</section>

<section class="about-panel about-panel--components mdl-color-text--white mdl-cell mdl-cell--6-col" data-target="components/index.html">
  Components
</section>
<section class="about-panel about-panel--styles mdl-color-text--white mdl-cell mdl-cell--6-col" data-target="styles/index.html">
  Styles
</section>
<section class="about-panel about-panel--customize mdl-color-text--white mdl-cell mdl-cell--12-col" data-target="customize/index.html">
  Customize
</section>

<section class="docs-text-styling about-panel about-panel--text mdl-cell mdl-cell--12-col">
  <p>
    The MDL component library includes new versions of common user interface controls such as buttons, check boxes, and text fields, adapted to follow Material Design concepts. The library also includes enhanced and specialized features like cards, column layouts, sliders, spinners, tabs, typography, and more. MDL is free to download and use, and may be used with or without any library or development environment (such as [Web Starter Kit](https://developers.google.com/web/starter-kit/)). It is a cross-browser, cross-OS web developer's toolkit that can be used by anyone who wants to write more productive, portable, and &mdash; most importantly &mdash; usable web pages.
  </p>
</section>
<script src="assets/index.js" async></script>
