<?php
session_start();
$aux_url = $_SESSION['aux_url'];
require_once($_SERVER['DOCUMENT_ROOT'].'/vgestion/lib_esp/fpdf16/fpdf.php');

class PDF extends FPDF
{
//Cargar los datos
function LoadData($file)
{
    //Leer las líneas del fichero
    $lines=file($file);
    $data=array();
    foreach($lines as $line)
        $data[]=explode(';',chop($line));
	return $data;
}
function carga_items()
{
	$data=array();
	$data[]=explode(';',chop('apellido:;'));
	$data[]=explode(';',chop('Nombre:;'));
	$data[]=explode(';',chop('Ocupacion:;'));
	$data[]=explode(';',chop('Hijos:;'));
	$data[]=explode(';',chop('Fecha de nacimiento:;'));
	$data[]=explode(';',chop('Intereses:;'));
	$data[]=explode(';',chop('Edad:;'));
	$data[]=explode(';',chop('Dni:;'));
	$data[]=explode(';',chop('Tel. particular:;'));
	$data[]=explode(';',chop('Movil:;'));
	$data[]=explode(';',chop('Laboral:;'));
	$data[]=explode(';',chop('Email:;'));
	$data[]=explode(';',chop('Calle:;;Calle:;'));
	$data[]=explode(';',chop('Numero:;'));
	$data[]=explode(';',chop('Piso:;'));
	$data[]=explode(';',chop('Depto:;'));
	$data[]=explode(';',chop('Barrio:;'));
	$data[]=explode(';',chop('Localidad:;'));
	$data[]=explode(';',chop('Provincia:;'));
	$data[]=explode(';',chop('Pais:;'));
	$data[]=explode(';',chop('Cp:;'));
	$data[]=explode(';',chop('Como conocio Elixir:;'));

	
	return $data;
}

//Tabla simple
function BasicTable($header,$data)
{
    //Cabecera
    foreach($header as $col)
        $this->Cell(40,7,$col,3);
    $this->Ln();
    //Datos
    foreach($data as $row)
    {
        foreach($row as $col)
            $this->Cell(40,6,$col,1);
        $this->Ln();
    }
}

//Una tabla más completa
function ImprovedTable($header,$data)
{
    //Anchuras de las columnas
    $w=array(40,125);
    //Cabeceras
    for($i=0;$i<count($header);$i++)
        $this->Cell($w[$i],7,$header[$i],1,0,'C');
    $this->Ln();
    //Datos
	$this->SetDrawColor(128,0,0);
    $this->SetLineWidth(.3);
    foreach($data as $row)
    {
		$this->Cell($w[0],6,$row[0],'LR');
        $this->Cell($w[1],6,$row[1],'LR');
        $this->Ln();
    }
    //Línea de cierre
    $this->Cell(array_sum($w),0,'','T');
}

//Tabla coloreada
function FancyTable($header,$data)
{
    //Colores, ancho de línea y fuente en negrita
    $this->SetFillColor(255,0,0);
    $this->SetTextColor(255);
    $this->SetDrawColor(128,0,0);
    $this->SetLineWidth(.3);
    $this->SetFont('','B');
    //Cabecera
    $w=array(40,125);
    for($i=0;$i<count($header);$i++)
        $this->Cell($w[$i],7,$header[$i],1,0,'C',1);
    $this->Ln();
    //Restauración de colores y fuentes
    $this->SetFillColor(224,235,255);
    $this->SetTextColor(0);
    $this->SetFont('');
    //Datos
    $fill=false;
    foreach($data as $row)
    {
        $this->Cell($w[0],6,$row[0],'LR',0,'L',$fill);
        $this->Cell($w[1],6,$row[1],'LR',0,'L',$fill);
        $this->Ln();
        $fill=!$fill;
    }
    $this->Cell(array_sum($w),0,'','T');
}
}

$pdf=new PDF();
//Títulos de las columnas
//$header=array('País','Capital','Superficie (km2)','Pobl. (en miles)');
$header=array('Datos Personales','');
//Carga de datos
//$data=$pdf->LoadData('datos_personales.txt');
$data=$pdf->carga_items();
$pdf->SetFont('Arial','',14);
$pdf->AddPage();
$pdf->ImprovedTable($header,$data);
$pdf->FancyTable($header,$data);
$pdf->BasicTable($header,$data);
/*
$pdf->AddPage();
$pdf->ImprovedTable($header,$data);
$pdf->AddPage();
$pdf->FancyTable($header,$data);
*/
$pdf->Output();
?>
