/*
 * Tweetie: A simple Twitter feed plugin
 * Author: Sonny T. <hi@sonnyt.com>, sonnyt.com
 */
(function ($) {
    'use strict';
    function isEmpty(obj) { if (typeof (obj) !== "undefined" && obj !== null && (obj.length > 0 || typeof (obj) == 'number' || typeof (obj.length) == "undefined") && obj !== "undefined") return false; else return true; }
    $.fn.twittie = function () {
        var e = arguments[0] instanceof Object ? arguments[0] : {},
            t = "function" == typeof arguments[0] ? arguments[0] : arguments[1],
            a = "";
        var p = $("script[src*='social.min.js']").attr("src");
        if (!isEmpty(p) && p.indexOf("social.min.js") > -1) a = p.substr(0, p.lastIndexOf("/")), !1
        var r = $.extend({
            username: null,
            list: null,
            hashtag: null,
            count: 10,
            hideReplies: !1,
            dateFormat: "%b/%d/%Y",
            template: '<div class="tweet-cnt"><a href="{{url}}" target="_blank">{{avatar}}</a><div class="tweets_txt">{{tweet}}<span>{{date}}</span></div></div>',
            apiPath: a + "/tweetie/api/tweet.php",
            loadingText: '<div class="feeds-loading"></div>'
        }, e);
        r.list && !r.username && $.error("If you want to fetch tweets from a list, you must define the username of the list owner.");
        var n = function (e) {
            return e.replace(/(https?:\/\/([-\w\.]+)+(:\d+)?(\/([\w\/_\.]*(\?\S+)?)?)?)/gi, '<a href="$1" target="_blank" title="Visit this link">$1</a>').replace(/#([a-zA-Z0-9_]+)/g, '<a href="https://twitter.com/search?q=%23$1&amp;src=hash" target="_blank" title="Search for #$1">#$1</a>').replace(/@([a-zA-Z0-9_]+)/g, '<a href="https://twitter.com/$1" target="_blank" title="$1 on Twitter">@$1</a>')
        },
            s = function (e) {
                for (var t = e.split(" "), a = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"], n = {
                    "%d": (e = new Date(Date.parse(t[1] + " " + t[2] + ", " + t[5] + " " + t[3] + " UTC"))).getDate(),
                    "%m": e.getMonth() + 1,
                    "%b": a[e.getMonth()].substr(0, 3),
                    "%B": a[e.getMonth()],
                    "%y": String(e.getFullYear()).slice(-2),
                    "%Y": e.getFullYear()
                }, s = r.dateFormat, i = r.dateFormat.match(/%[dmbByY]/g), l = 0, u = i.length; l < u; l++) s = s.replace(i[l], n[i[l]]);
                return s
            },
            i = function (e) {
                for (var t = r.template, a = ["date", "tweet", "avatar", "url", "retweeted", "screen_name", "user_name"], n = 0, s = a.length; n < s; n++) t = t.replace(new RegExp("{{" + a[n] + "}}", "gi"), e[a[n]]);
                return t
            };
        this.html("<span>" + r.loadingText + "</span>");
        var l = this;
        $.getJSON(r.apiPath, {
            username: r.username,
            list: r.list,
            hashtag: r.hashtag,
            count: r.count,
            exclude_replies: r.hideReplies
        }, function (e) {
            l.find("span").fadeOut("fast", function () {
                l.html("<ul></ul>");
                for (var a = 0; a < r.count; a++) {
                    var u = !1;
                    if (e[a]) u = e[a];
                    else {
                        if (void 0 === e.statuses || !e.statuses[a]) break;
                        u = e.statuses[a]
                    }
                    var c = u.retweeted ? u.retweeted_status.text : u.text;
                    null != r.length && c.length > r.length && (c = c.substr(0, parseInt(r.length)) + "..."), c = n(u.retweeted ? "RT @" + u.user.screen_name + ": " + c : c);
                    var h = {
                        user_name: u.user.name,
                        date: s(u.created_at),
                        tweet: c,
                        avatar: '<img src="' + u.user.profile_image_url + '" />',
                        url: "https://twitter.com/" + u.user.screen_name + "/status/" + u.id_str,
                        retweeted: u.retweeted,
                        screen_name: n("@" + u.user.screen_name)
                    };
                    l.find("ul").append("<li>" + i(h) + "</li>")
                }
                "function" == typeof t && t()
            })
        