/**
 *  Trip.js
 *
 *  This is a jQuery plugin that can help you customize your tutorial trip
 *  with full flexibilities.
 *
 *  Version: 3.3.5
 *
 *  Author: EragonJ <eragonj@eragonj.me>
 *  Blog: http://eragonj.me
 *
 *  @preserve
 */
!function(root,factory){"object"==typeof exports&&"object"==typeof module?module.exports=factory(require("jquery")):"function"==typeof define&&define.amd?define("Trip",["jquery"],factory):"object"==typeof exports?exports.Trip=factory(require("jquery")):root.Trip=factory(root.jQuery)}(this,function(__WEBPACK_EXTERNAL_MODULE_1__){return function(modules){function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:!1};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.loaded=!0,module.exports}var installedModules={};return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.p="",__webpack_require__(0)}([function(module,exports,__webpack_require__){function Trip(){var userOptions,tripData,noop=function(){},tripParser=new TripParser;if(0===arguments.length)tripData=tripParser.parse("default"),userOptions={};else if(1===arguments.length)if(TripUtils.isArray(arguments[0]))tripData=arguments[0],userOptions={};else if(TripUtils.isObject(arguments[0]))tripData=tripParser.parse("default"),userOptions=arguments[0];else{if(!TripUtils.isString(arguments[0]))throw"Please check documents for passing parameters, you may pass wrong parameters into constructor function !";tripData=tripParser.parse(arguments[0]),userOptions={}}else TripUtils.isArray(arguments[0])?tripData=arguments[0]:TripUtils.isString(arguments[0])&&(tripData=tripParser.parse(arguments[0])),userOptions=arguments[1];if(this.settings=$.extend({tripClass:"",tripIndex:0,tripTheme:"black",backToTopWhenEnded:!1,overlayHolder:"body",overlayZindex:99999,delay:1e3,enableKeyBinding:!0,enableAnimation:!0,showSteps:!1,showCloseBox:!1,showHeader:!1,skipUndefinedTrip:!1,stopClickPropagation:!1,showNavigation:!1,canGoNext:!0,canGoPrev:!0,nextLabel:"Next",prevLabel:"Back",finishLabel:"Dismiss",closeBoxLabel:"&#215;",skipLabel:"Skip",header:"Step {{tripIndex}}",onStart:noop,onEnd:noop,onTripStart:noop,onTripEnd:noop,onTripStop:noop,onTripPause:noop,onTripResume:noop,onTripChange:noop,onTripClose:noop,animation:"fadeIn"},userOptions),!this.settings.tripBlockHTML){var html=TripTheme.get(this.settings.tripTheme);html||(html=TripTheme.get("default")),this.settings.tripBlockHTML=html}this.tripData=tripData,this.$tripBlock=null,this.$overlay=null,this.$bar=null,this.$root=$("html"),this.tripDirection="next",this.timer=null,this.progressing=!1,this.hasExposedElements=!1,this.CONSTANT=TripConstant}module.exports=Trip;var $=__webpack_require__(1),TripParser=__webpack_require__(2),TripUtils=__webpack_require__(3),TripAnimation=__webpack_require__(4),TripTheme=__webpack_require__(5),TripConstant=__webpack_require__(9);Trip.prototype={showExposedElements:function(){var oldCSS,newCSS,$sel,o=this.getCurrentTripObject();$sel="string"==typeof o.expose?$(o.expose):o.expose instanceof $?o.expose:$(o.sel),this.hasExposedElements=!0,void 0!==$sel.get(0)&&(oldCSS={position:$sel.css("position"),zIndex:$sel.css("z-Index")},newCSS={position:function(){return["absolute","fixed"].indexOf(oldCSS.position)>-1?oldCSS.position:"relative"}(),zIndex:this.settings.overlayZindex+1},$sel.data("trip-old-css",oldCSS).css(newCSS).addClass("trip-exposed"))},hideExposedElements:function(){var $exposedSel=$(".trip-exposed");if(this.hasExposedElements=!1,void 0!==$exposedSel.get(0)){var oldCSS=$exposedSel.data("trip-old-css");$exposedSel.css(oldCSS).removeClass("trip-exposed")}},bindResizeEvents:function(){var timer,that=this;$(window).on("resize.Trip",function(){window.clearTimeout(timer),timer=window.setTimeout(function(){that.run()},TripConstant.RESIZE_TIMEOUT)})},unbindResizeEvents:function(){$(window).off("resize.Trip")},bindKeyEvents:function(){var that=this;$(document).on({"keydown.Trip":function(e){that.keyEvent.call(that,e)}})},unbindKeyEvents:function(){$(document).off("keydown.Trip")},keyEvent:function(e){switch(e.which){case TripConstant.ESC:this.stop();break;case TripConstant.SPACE:e.preventDefault(),this.pause();break;case TripConstant.LEFT_ARROW:case TripConstant.UP_ARROW:this.prev();break;case TripConstant.RIGHT_ARROW:case TripConstant.DOWN_ARROW:this.next()}},stop:function(){this.timer&&(this.timer.stop(),this.timer=null),this.hasExposedElements&&(this.hideExposedElements(),this.toggleExposedOverlay(!1)),this.hideTripBlock(),this.unbindKeyEvents(),this.unbindResizeEvents();var tripObject=this.getCurrentTripObject();tripObject.nextClickSelector&&$(tripObject.nextClickSelector).off("click.Trip");var tripStop=tripObject.onTripStop||this.settings.onTripStop;tripStop.call(this,this.tripIndex,tripObject),this.settings.onEnd(this.tripIndex,tripObject),this.setIndex(this.settings.tripIndex)},pauseOrResume:function(){if(this.timer){if(this.progressing)this.timer.pause(),this.pauseProgressBar();else{var remainingTime=this.timer.resume();this.resumeProgressBar(remainingTime)}this.progressing=!this.progressing}},pause:function(){this.pauseOrResume();var tripObject=this.getCurrentTripObject(),tripPause=tripObject.onTripPause||this.settings.onTripPause;tripPause.call(this,this.tripIndex,tripObject)},resume:function(){this.pauseOrResume();var tripObject=this.getCurrentTripObject(),tripResume=tripObject.onTripResume||this.settings.onTripResume;tripResume.call(this,this.tripIndex,tripObject)},next:function(tripIndex){var that=this,useDifferentIndex=!isNaN(tripIndex);if(useDifferentIndex||this.canGoNext()){this.tripDirection="next";var tripObject=this.getCurrentTripObject(),tripEnd=tripObject.onTripEnd||this.settings.onTripEnd,tripEndDefer=tripEnd.call(this,this.tripIndex,tripObject);$.when(tripEndDefer).then(function(){return useDifferentIndex?(that.timer&&that.timer.stop(),that.setIndex(tripIndex),void that.run()):void(that.isLast()?that.doLastOperation():(that.increaseIndex(),that.run()))})}},prev:function(){var that=this;if(this.canGoPrev()){this.tripDirection="prev";var tripObject=this.getCurrentTripObject(),tripEnd=tripObject.onTripEnd||this.settings.onTripEnd,tripEndDefer=tripEnd(this.tripIndex,tripObject);$.when(tripEndDefer).then(function(){that.isFirst()||that.decreaseIndex(),that.run()})}},showCurrentTrip:function(o){this.removeAnimation(),this.timer&&(this.timer.stop(),this.timer=null),this.hasExposedElements&&(this.hideExposedElements(),o.expose||this.toggleExposedOverlay(!1)),this.progressing&&(this.hideProgressBar(),this.progressing=!1),this.setTripBlock(o),this.showTripBlock(o),TripUtils.isSet(o.enableAnimation,this.settings.enableAnimation)&&this.addAnimation(o),o.expose&&(this.showExposedElements(),this.toggleExposedOverlay(!0))},doLastOperation:function(){this.timer&&(this.timer.stop(),this.timer=null),this.settings.enableKeyBinding&&this.unbindKeyEvents(),this.hideTripBlock(),this.unbindResizeEvents(),this.hasExposedElements&&(this.hideExposedElements(),this.toggleExposedOverlay(!1)),this.settings.backToTopWhenEnded&&this.$root.animate({scrollTop:0},"slow");var tripObject=this.getCurrentTripObject();this.settings.onEnd(this.tripIndex,tripObject),this.setIndex(this.settings.tripIndex)},showProgressBar:function(delay){var that=this;this.$bar.animate({width:"100%"},delay,"linear",function(){that.$bar.width(0)})},hideProgressBar:function(){this.$bar.width(0),this.$bar.stop(!0)},pauseProgressBar:function(){this.$bar.stop(!0)},resumeProgressBar:function(remainingTime){this.showProgressBar(remainingTime)},run:function(){var that=this,tripObject=this.getCurrentTripObject(),tripStart=tripObject.onTripStart||this.settings.onTripStart,tripChange=tripObject.onTripChange||this.settings.onTripChange,delay=tripObject.delay||this.settings.delay;return this.isTripDataValid(tripObject)?(this.showCurrentTrip(tripObject),this.showProgressBar(delay),this.progressing=!0,tripChange.call(this,this.tripIndex,tripObject),tripStart.call(this,this.tripIndex,tripObject),void(delay>=0&&(this.timer=new TripUtils.Timer(function(){that.next()},delay)))):this.settings.skipUndefinedTrip===!1?(TripUtils.log("Your tripData is not valid at index: "+this.tripIndex),this.stop(),!1):this[this.tripDirection]()},isFirst:function(){return 0===this.tripIndex},isLast:function(){return this.tripIndex===this.tripData.length-1},isTripDataValid:function(o){return!!this.hasSpecialDirections()||(!o.nextClickSelector||0!==$(o.nextClickSelector).length)&&("undefined"!=typeof o.content&&"undefined"!=typeof o.sel&&null!==o.sel&&0!==o.sel.length&&0!==$(o.sel).length)},hasSpecialDirections:function(){var o=this.getCurrentTripObject(),position=o.position,specialDirections=["screen-ne","screen-se","screen-sw","screen-nw","screen-center"];return $.inArray(position,specialDirections)>=0},canGoPrev:function(){var tripObject=this.getCurrentTripObject(),canGoPrev=tripObject.canGoPrev;return"undefined"==typeof canGoPrev&&(canGoPrev=this.settings.canGoPrev),"function"==typeof canGoPrev&&(canGoPrev=canGoPrev.call(this,this.tripIndex,tripObject)),0===this.tripIndex&&(canGoPrev=!1),canGoPrev},canGoNext:function(){var tripObject=this.getCurrentTripObject(),canGoNext=tripObject.canGoNext;return"undefined"==typeof canGoNext&&(canGoNext=this.settings.canGoNext),"function"==typeof canGoNext&&(canGoNext=canGoNext.call(this,this.tripIndex,tripObject)),canGoNext},setIndex:function(tripIndex){tripIndex=Math.max(0,Math.min(tripIndex,this.tripData.length-1)),this.tripIndex=tripIndex,this.$tripBlock.attr("data-trip-step",this.tripIndex)},increaseIndex:function(){this.setIndex(this.tripIndex+1)},decreaseIndex:function(){this.setIndex(this.tripIndex-1)},getCurrentTripObject:function(){return this.tripData[this.tripIndex]},getReplacedTripContent:function(content){content=content||"";var reTripIndex=/\{\{(tripIndex)\}\}/g,reTripTotal=/\{\{(tripTotal)\}\}/g;return content=content.replace(reTripIndex,this.tripIndex+1),content=content.replace(reTripTotal,this.tripData.length)},setTripBlock:function(o){var $tripBlock=this.$tripBlock,that=this,showCloseBox=TripUtils.isSet(o.showCloseBox,this.settings.showCloseBox),showNavigation=TripUtils.isSet(o.showNavigation,this.settings.showNavigation),showHeader=TripUtils.isSet(o.showHeader,this.settings.showHeader),showSteps=TripUtils.isSet(o.showSteps,this.settings.showSteps),closeBoxLabel=o.closeBoxLabel||this.settings.closeBoxLabel,prevLabel=o.prevLabel||this.settings.prevLabel,nextLabel=o.nextLabel||this.settings.nextLabel,finishLabel=o.finishLabel||this.settings.finishLabel,skipLabel=o.skipLabel||this.settings.skipLabel,header=o.header||this.settings.header;$tripBlock.find(".trip-header").html(this.getReplacedTripContent(header)).toggle(showHeader),$tripBlock.find(".trip-content").html(this.getReplacedTripContent(o.content)),$tripBlock.find(".trip-prev").toggleClass("disabled",!this.canGoPrev()).html(prevLabel).toggle(showNavigation),$tripBlock.find(".trip-next").toggleClass("disabled",!this.canGoNext()).html(this.isLast()?finishLabel:nextLabel).toggle(showNavigation&&!o.nextClickSelector),$tripBlock.find(".trip-skip").html(skipLabel).toggle(showNavigation),$tripBlock.find(".trip-close").html(closeBoxLabel).toggle(showCloseBox),$tripBlock.find(".trip-progress-steps").toggle(showSteps).find(".trip-progress-step").not(":eq("+this.tripIndex+")").removeClass("selected").end().eq(this.tripIndex).addClass("selected"),$tripBlock.removeClass("e s w n screen-ne screen-se screen-sw screen-nw screen-center"),$tripBlock.addClass(o.position),o.nextClickSelector&&($(o.nextClickSelector).off("click.Trip"),$(o.nextClickSelector).one("click.Trip",function(e){e.preventDefault(),$(this).blur(),that.next()})),this.setTripBlockPosition(o,"horizontal"),this.setTripBlockPosition(o,"vertical")},setTripBlockPosition:function(o,horizontalOrVertical){var $tripBlock=this.$tripBlock;"horizontal"===horizontalOrVertical?$tripBlock.css({left:"",right:"",marginLeft:""}):"vertical"===horizontalOrVertical&&$tripBlock.css({top:"",bottom:"",marginTop:""});var $sel=$(o.sel),selWidth=$sel&&$sel.outerWidth(),selHeight=$sel&&$sel.outerHeight(),blockWidth=$tripBlock.outerWidth(),blockHeight=$tripBlock.outerHeight(),arrowHeight=10,arrowWidth=10,cssHorizontal=this.getIframeScrollLeft(o),cssVertical=this.getIframeScrollTop(o);switch(o.position){case"screen-center":cssHorizontal="50%",cssVertical="50%";break;case"screen-ne":case"screen-se":case"screen-nw":case"screen-sw":cssHorizontal=TripConstant.TRIP_BLOCK_OFFSET_HORIZONTAL,cssVertical=TripConstant.TRIP_BLOCK_OFFSET_VERTICAL;break;case"e":cssHorizontal+=$sel.offset().left+selWidth+arrowWidth,cssVertical+=$sel.offset().top-(blockHeight-selHeight)/2;break;case"s":cssHorizontal+=$sel.offset().left+(selWidth-blockWidth)/2,cssVertical+=$sel.offset().top+selHeight+arrowHeight;break;case"w":cssHorizontal+=$sel.offset().left-(arrowWidth+blockWidth),cssVertical+=$sel.offset().top-(blockHeight-selHeight)/2;break;case"n":default:cssHorizontal+=$sel.offset().left+(selWidth-blockWidth)/2,cssVertical+=$sel.offset().top-arrowHeight-blockHeight}if("horizontal"===horizontalOrVertical)switch(o.position){case"screen-center":$tripBlock.css({left:cssHorizontal,marginLeft:-.5*blockWidth});break;case"screen-se":case"screen-ne":$tripBlock.css({right:cssHorizontal});break;case"screen-sw":case"screen-nw":case"e":case"s":case"w":case"n":default:$tripBlock.css({left:cssHorizontal})}else if("vertical"===horizontalOrVertical)switch(o.position){case"screen-center":$tripBlock.css({top:cssVertical,marginTop:-.5*blockHeight});break;case"screen-sw":case"screen-se":$tripBlock.css({bottom:cssVertical});break;case"screen-nw":case"screen-ne":case"e":case"s":case"w":case"n":default:$tripBlock.css({top:cssVertical})}},addAnimation:function(o){var animation=o.animation||this.settings.animation;TripAnimation.has(animation)&&(this.$tripBlock.addClass("animated"),this.$tripBlock.addClass(animation))},removeAnimation:function(){this.$tripBlock.removeClass(TripAnimation.getAllInString()),this.$tripBlock.removeClass("animated")},showTripBlock:function(o){this.$tripBlock.css({display:"inline-block",zIndex:this.settings.overlayZindex+1});var windowHeight=$(window).height(),windowTop=$(window).scrollTop(),frameTop=this.getIframeScrollTop(o);0!=frameTop&&(frameTop-=windowTop);var tripBlockTop=this.$tripBlock.offset().top+frameTop,tripBlockHeight=this.$tripBlock.height(),OFFSET=100;tripBlockTop+tripBlockHeight<windowTop+windowHeight&&tripBlockTop>=windowTop||this.$root.animate({scrollTop:tripBlockTop-OFFSET},"slow")},getIframeScrollTop:function(o){if($(o.sel).parents("html")[0]!=this.$tripBlock.parents("html")[0]){var offsetTop=0;return $(document).find("iframe").each(function(index,frame){if($(frame).contents().has($(o.sel)))return offsetTop=$(frame).offset().top,!1}),offsetTop-$(o.sel).parents("html,body").scrollTop()}return 0},getIframeScrollLeft:function(o){if($(o.sel).parents("html")[0]!=this.$tripBlock.parents("html")[0]){var offsetLeft=0;return $(document).find("iframe").each(function(index,frame){if($(frame).contents().has($(o.sel)))return offsetLeft=$(frame).offset().left,!1}),offsetLeft-$(o.sel).parents("html,body").scrollLeft()}return 0},hideTripBlock:function(){this.removeAnimation(),this.$tripBlock.fadeOut("slow")},create:function(){this.createTripBlock(),this.createOverlay()},createTripBlock:function(){if("undefined"==typeof $(".trip-block").get(0)){var that=this,tripBlockHTML=this.settings.tripBlockHTML,$tripBlock=$(tripBlockHTML);$tripBlock.addClass(this.settings.tripTheme).addClass(this.settings.tripClass).addClass("tripjs"),$("html>body").append($tripBlock);var $progressSteps=$tripBlock.find(".trip-progress-steps");if($progressSteps){for(var stepCache=[],$step=$('<div class="trip-progress-step"></div>'),i=0;i<this.tripData.length;i++)stepCache.push($step.clone());$progressSteps.append(stepCache)}$tripBlock.off("click.Trip"),$tripBlock.on("click.Trip",function(e){var tripObject=that.getCurrentTripObject(),toStopClickPropagation=TripUtils.isSet(tripObject.stopClickPropagation,that.settings.stopClickPropagation);toStopClickPropagation&&e.stopPropagation()});var $closeButton=$tripBlock.find(".trip-close");$closeButton&&($closeButton.off("click.Trip"),$closeButton.on("click.Trip",function(e){e.preventDefault();var tripObject=that.getCurrentTripObject(),tripClose=tripObject.onTripClose||that.settings.onTripClose;tripClose.call(that,that.tripIndex,tripObject),that.stop()}));var $skipButton=$tripBlock.find(".trip-skip");$skipButton&&($skipButton.off("click.Trip"),$skipButton.on("click.Trip",function(e){e.preventDefault();var tripObject=that.getCurrentTripObject(),tripClose=tripObject.onTripClose||that.settings.onTripClose;tripClose.call(that,that.tripIndex,tripObject),that.stop()}));var $prevButton=$tripBlock.find(".trip-prev");$prevButton&&($prevButton.off("click.Trip"),$prevButton.on("click",function(e){e.preventDefault(),$(this).blur(),that.prev()}));var $nextButton=$tripBlock.find(".trip-next");$nextButton&&($nextButton.off("click.Trip"),$nextButton.on("click",function(e){e.preventDefault(),$(this).blur(),that.next()}))}},createOverlay:function(){if("undefined"==typeof $(".trip-overlay").get(0)){var html=['<div class="trip-overlay">',"</div>"].join(""),$overlay=$(html);$overlay.height($(window).height()).css({zIndex:this.settings.overlayZindex}),$(this.settings.overlayHolder).append($overlay)}},toggleExposedOverlay:function(toShow){toShow?this.$overlay.fadeIn():this.$overlay.fadeOut()},cleanup:function(){$(".trip-overlay, .trip-block").remove()},init:function(){this.settings.enableKeyBinding&&this.bindKeyEvents(),this.bindResizeEvents(),this.$tripBlock=$(".trip-block"),this.$bar=$(".trip-progress-bar"),this.$overlay=$(".trip-overlay"),this.setIndex(this.settings.tripIndex)},start:function(){this.cleanup(),this.settings.onStart.call(this),this.create(),this.init(),this.run()}}},function(module,exports){module.exports=__WEBPACK_EXTERNAL_MODULE_1__},function(module,exports){function TripParser(){this._DEFAULT_TRIP_NODES_SELECTOR="[data-trip]",this._DEFAULT_TRIP_POSITION="n",this._DEFAULT_TRIP_ANIMATION="tada"}module.exports=TripParser,TripParser.prototype={_getAllTripNodes:function(selector){return document.querySelectorAll(selector)},_parseTripData:function(node){var tripIndex=node.dataset.tripIndex,tripContent=node.dataset.tripContent,tripDelay=node.dataset.tripDelay,tripExpose="true"===node.dataset.tripExpose||(node.dataset.tripExpose||!1),tripPosition=node.dataset.tripPosition||this._DEFAULT_TRIP_POSITION;node.dataset.tripAnimation||this._DEFAULT_TRIP_ANIMATION;if(node&&"undefined"!=typeof tripIndex&&""!==tripContent){tripIndex=parseInt(tripIndex,10),tripDelay=parseInt(tripDelay,10);var tripObject={};return tripObject.sel=node,tripObject._index=tripIndex,tripObject.position=tripPosition,tripObject.content=tripContent,tripObject.expose=tripExpose,tripDelay&&!isNaN(tripDelay)&&(tripObject.delay=tripDelay),tripObject}return null},_sort:function(tripData){tripData.sort(function(dataA,dataB){return dataA._index-dataB._index})},parse:function(selector){if("string"!=typeof selector)throw"Please check your selector - "+selector+" , and make sure  it is String type";selector="default"===selector?this._DEFAULT_TRIP_NODES_SELECTOR:selector;var that=this,tripData=[],nodes=this._getAllTripNodes(selector);return nodes&&[].forEach.call(nodes,function(node){var tripDataForThatNode=that._parseTripData(node);tripDataForThatNode&&tripData.push(tripDataForThatNode)}),this._sort(tripData),tripData}}},function(module,exports){var TripUtils={isArray:function(target){return"[object Array]"===Object.prototype.toString.call(target)},isObject:function(target){return"[object Object]"===Object.prototype.toString.call(target)},isString:function(target){return"string"==typeof target},isSet:function(localSetting,globalSetting){return"undefined"!=typeof localSetting?localSetting:globalSetting},log:function(){var console=window.console;"undefined"!=typeof console&&console.log&&console.log.apply(console,arguments)},Timer:function(callback,delay){var timerId,start,remaining=delay;this.pause=function(){window.clearTimeout(timerId),remaining-=new Date-start},this.resume=function(){return start=new Date,timerId=window.setTimeout(callback,remaining),remaining},this.stop=function(){window.clearTimeout(timerId)},this.resume()}};module.exports=TripUtils},function(module,exports){function TripAnimation(){}module.exports=TripAnimation;var animations=["flash","bounce","shake","tada","fadeIn","fadeInUp","fadeInDown","fadeInLeft","fadeInRight","fadeInUpBig","fadeInDownBig","fadeInLeftBig","fadeInRightBig","bounceIn","bounceInDown","bounceInUp","bounceInLeft","bounceInRight","rotateIn","rotateInDownLeft","rotateInDownRight","rotateInUpLeft","rotateInUpRight"];TripAnimation.has=function(name){return animations.indexOf(name)>=0},TripAnimation.getAllInString=function(){return animations.join(" ")}},function(module,exports,__webpack_require__){function TripTheme(){}module.exports=TripTheme;var Themes=__webpack_require__(6);TripTheme.get=function(name){var theme=Themes[name];return theme}},function(module,exports,__webpack_require__){module.exports={black:__webpack_require__(7),dark:__webpack_require__(7),white:__webpack_require__(7),yeti:__webpack_require__(7),"default":__webpack_require__(7),minimalism:__webpack_require__(8)}},function(module,exports){module.exports=['<div class="trip-block">','<a href="#" class="trip-close"></a>','<div class="trip-header"></div>','<div class="trip-content"></div>','<div class="trip-progress-steps"></div>','<div class="trip-navigation">','<a href="#" class="trip-prev"></a>','<a href="#" class="trip-skip"></a>','<a href="#" class="trip-next"></a>',"</div>",'<div class="trip-progress-bar"></div>',"</div>"].join("")},function(module,exports){module.exports=['<div class="trip-block">','<a href="#" class="trip-close"></a>','<div class="trip-header"></div>','<div class="trip-content"></div>','<div class="trip-progress-steps"></div>','<div class="trip-navigation">','<a href="#" class="trip-prev"></a>','<a href="#" class="trip-next"></a>','<a href="#" class="trip-skip"></a>',"</div>",'<div class="trip-progress-bar"></div>',"</div>"].join("")},function(module,exports){module.exports={LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,ESC:27,SPACE:32,TRIP_BLOCK_OFFSET_VERTICAL:10,TRIP_BLOCK_OFFSET_HORIZONTAL:10,RESIZE_TIMEOUT:200}}])});