(function ($) {
    'use strict';

    $.fn.bootstrapTable.locales['en-US'] = {
        formatLoadingMessage: function () {
            return 'Loading, please wait...';
        },
        formatRecordsPerPage: function (pageNumber) {
            return pageNumber + ' rows per page';
        },
        formatShowingRows: function (pageFrom, pageTo, totalRows) {
            return 'Showing ' + pageFrom + ' to ' + pageTo + ' of ' + totalRows + ' rows';
        },
        formatSearch: function () {
            return 'Search';
        },
        formatNoMatches: function () {
            return 'No matching records found';
        },
        formatPaginationSwitch: function () {
            return 'Hide/Show pagination';
        },
        formatRefresh: function () {
            return 'Refresh';
        },
        formatToggle: function () {
            return 'Toggle';
        },
        formatColumns: function () {
            return 'Columns';
        },
        formatAllRows: function () {
            return 'All';
        },
		formatFilterDatepickerPlaceholder: function(){
            return 'dd.mm.yyyy';
        },
        formatFilterDatepickerPlaceholderFrom: function(){
            return 'from dd.mm.yyyy';
        },
        formatFilterDatepickerPlaceholderTo: function(){
            return 'to dd.mm.yyyy';
        },
        formatFilter: function () {
            return 'Start filter';
        },
        formatResetFilter: function () {
            return 'Reset filter';
        },
		formatFilterSelectLabel: function () {
            return 'All';
        }
    };

    $.extend($.fn.bootstrapTable.defaults, $.fn.bootstrapTable.locales['en-US']);

})(jQuery);