<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script type="text/javascript">

// when the DOM is ready...
$(document).ready(function () {
  $('#timeline').mousedown(function (event) {
    // attach 3 pieces of data to the #timeline element
    $(this)
      .data('down', true) // a flag indicating the mouse is down
      .data('x', event.clientX) // the current mouse down X coord
      .data('scrollLeft', this.scrollLeft); // the current scroll position
        
    // return false to avoid selecting text and dragging links within the scroll window
    return false;
  }).mouseup(function (event) {
    // on mouse up, cancel the 'down' flag
    $(this).data('down', false);
  }).mousemove(function (event) {
    // if the mouse is down - start the drag effect
    if ($(this).data('down') == true) {
      // this.scrollLeft is the scrollbar caused by the overflowing content
      // the new position is: original scroll position + original mouse down X - new X
      // I'd like to see if anyone can give an example of how to speed up the scroll.
      this.scrollLeft = $(this).data('scrollLeft') + $(this).data('x') - event.clientX;
    }
  }).mousewheel(function (event, delta) {
    // now attaching the mouse wheel plugin and scroll by the 'delta' which is the
    // movement of the wheel - so we multiple by an arbitrary number.
    this.scrollLeft -= (delta * 30);
  }).css({
    'overflow' : 'hidden', // change to hidden for JS users
    'cursor' : '-moz-grab' // add the grab cursor
  });
});

// finally, we want to handle the mouse going out of the browser window and
// it not triggering the mouse up event (because the mouse is still down)
// but it messes up the tracking of the mouse down
$(window).mouseout(function (event) {
  if ($('#timeline').data('down')) {
    try {
      // *try* to get the element the mouse left the window by and if
      // we really did leave the window, then cancel the down flag
      if (event.originalTarget.nodeName == 'BODY' || event.originalTarget.nodeName == 'HTML') {
        $('#timeline').data('down', false);
      }                
    } catch (e) {}
  }
});
$(document).ready(function () {
  // capture the rainbow element
  var rainbow = document.getElementById('rainbow'), 
    lastPos, // stores the last scrollLeft position
    width = 1656; // the repeating point on the background
  
  // we always reset when the page reloads so that the background is always the same
  rainbow.scrollLeft = width;
  
  // use an interval to scroll the rainbow
  setInterval(function () {
    // subtract to make the background scroll from left to right
    rainbow.scrollLeft -= 5;
    
    // if we've hit the beginning then the lastPos will be the same as the scrollLeft
    if (lastPos == rainbow.scrollLeft) {
      // reset
      rainbow.scrollLeft = width;
    }
    
    lastPos = rainbow.scrollLeft;
  }, 100); // the combination of milliseconds 
});
</script>
<title>Untitled Document</title>

<style type="text/css">
#timeline {
  height: 375px; /* fixed */
  overflow: auto; /* changed to hidden via JavaScript */
}

.tl-events { /* the UL */
  width: 11800px; /* the width required to hold all the info */
}

.tl-events li {
  float: left; /* allows the lis to stack against eachother */
  width: 300px;
}
#headerEffect {
  position: absolute;
  width: 100%;
  height: 400px;
  overflow: hidden;
  top: 0; /* make sure IE stretches it properly */
  left: 0;
}

#rainbow {
  height: 400px;
  width: 100%;
  overflow: hidden;
}

#rainbow div {
  height: 400px;
  width: 3312px; /* nice big width that ensures it repeats */
  background: url(/css/img/header.colour.3.png) repeat-x scroll -20% 0;
}

#swirl {
  background: url(/css/img/header.swirl.png) no-repeat scroll 50% 0;
  height: 400px;
  width: 100%;
  position: absolute; /* places the swirl *over* the rainbow */
  top: 0;
  left: 0;
}
</style>

</head>

<body>
<div id="headerEffect">
  <div id="rainbow"><div></div></div>
  <div id="swirl"></div>
</div>
</body>
</html>
